@extends('layouts.app')

@section('content')
<div class="container mx-auto">
    <h1 class="text-2xl font-bold">{{ $product->name }}</h1>
    <p class="mt-4">{{ $product->description }}</p>
    <p class="mt-2 text-lg font-semibold">Price: ${{ $product->price }}</p>

    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <h2 class="text-xl font-bold mt-6">Reviews</h2>
    <div class="mt-4">
        @foreach ($product->reviews as $review)
            <div class="border p-4 mb-4">
                <p><strong>{{ $review->user->name }}</strong> rated {{ $review->rating }}/5</p>
                <p>{{ $review->comment }}</p>
            </div>
        @endforeach
    </div>

    @auth
        <form method="POST" action="{{ route('reviews.store', $product) }}" class="mt-6">
            @csrf
            <div class="mb-4">
                <label for="rating" class="form-label">Rating</label>
                <select id="rating" name="rating" class="form-control" required>
                    <option value="">Select a rating</option>
                    @for ($i = 1; $i <= 5; $i++)
                        <option value="{{ $i }}">{{ $i }}</option>
                    @endfor
                </select>
            </div>

            <div class="mb-4">
                <label for="comment" class="form-label">Comment</label>
                <textarea id="comment" name="comment" class="form-control" rows="4"></textarea>
            </div>

            <button type="submit" class="btn btn-primary">Submit Review</button>
        </form>
    @endauth
</div>
@endsection